<?php

//返回签名和变量地址
function alipay_GetSignUrl($r,$novar=''){
	global $epay_setconfig;
	$sign='';
	//签名步骤一：按字典序排序参数
	ksort($r);
	$paystr_r=epay_ToUrlParams($r,$novar);
	$paystr=$paystr_r['str'];
	$paystrurl=$paystr_r['strurl'];
	//签名步骤二：加密
	$sign=alipay_doenstr($paystr,'RSA2');
	//返回参数
	$re_r['str']=$paystr;
	$re_r['strurl']=$paystrurl;
	$re_r['strsign']=$sign;
	return $re_r;
}

//加密
function alipay_doenstr($data,$signType='RSA2'){
	global $epay_setconfig;
	if(!function_exists('openssl_sign'))
	{
		echo'Not install openssl.';
		exit();
	}
	if(!$epay_setconfig['epaykeyfile'])
	{
		$priKey=$epay_setconfig['epaykey'];
		$res="-----BEGIN RSA PRIVATE KEY-----\n".wordwrap($priKey,64,"\n",true)."\n-----END RSA PRIVATE KEY-----";
	}
	else
	{
		$priKey=file_get_contents($epay_setconfig['epaykeyfile']);
		$res=openssl_get_privatekey($priKey);
	}
	if(!$res)
	{
		echo'Private key error.';
		exit();
	}
	if("RSA2"==$signType)
	{
		openssl_sign($data,$sign,$res,OPENSSL_ALGO_SHA256);
	}
	else
	{
		openssl_sign($data,$sign,$res);
	}
	if($epay_setconfig['epaykeyfile'])
	{
		openssl_free_key($res);
	}
	$sign=base64_encode($sign);
	return $sign;
}

//加密比较
function alipay_ckenstr($data,$sign,$signType='RSA2'){
	global $epay_setconfig;
	if(!function_exists('openssl_sign'))
	{
		echo'Not install openssl.';
		exit();
	}
	if(!$epay_setconfig['epaykeypubfile'])
	{
		$pubKey=$epay_setconfig['epaykeypub'];
		$res="-----BEGIN PUBLIC KEY-----\n".wordwrap($pubKey,64,"\n",true)."\n-----END PUBLIC KEY-----";
	}
	else
	{
		$pubKey=file_get_contents($epay_setconfig['epaykeypubfile']);
		$res=openssl_get_publickey($pubKey);
	}
	if(!$res)
	{
		echo'Public key error.';
		exit();
	}
	if("RSA2"==$signType)
	{
		$result=(bool)openssl_verify($data,base64_decode($sign),$res,OPENSSL_ALGO_SHA256);
	}
	else
	{
		$result=(bool)openssl_verify($data,base64_decode($sign),$res);
	}
	if($epay_setconfig['epaykeypubfile'])
	{
		openssl_free_key($res);
	}
	return $result;
}

//验签1：(去除sign_type参数)
function alipay_CheckSign($params,$signType='RSA2'){
	$sign=$params['sign'];
	$params['sign_type']='';
	$params['sign']='';
	//待签名内容
	ksort($params);
	$paystr_r=epay_ToUrlParams($params,'sign,sign_type');
	$data=$paystr_r['str'];
	//返回
	return alipay_ckenstr($data,$sign,$signType);
}

//验签2：(保留sign_type参数)
function alipay_CheckSignTwo($params,$signType='RSA2'){
	$sign=$params['sign'];
	$params['sign']='';
	//待签名内容
	ksort($params);
	$paystr_r=epay_ToUrlParams($params,'sign');
	$data=$paystr_r['str'];
	//返回
	return alipay_ckenstr($data,$sign,$signType);
}

//查询订单
function alipay_orderQuery($paycsr){
	global $epay_setconfig;
	//初始变量
	$epay_paycsr=array();

	//------------------ 参数开始 ------------------
	
	$epay_paycsr['app_id']=$epay_setconfig['epayuser'];	//应用ID
	
	$epay_paycsr['method']='alipay.trade.query';	//接口名称
	
	$epay_paycsr['format']=$epay_setconfig['epayformat'];	//内容格式
	
	$epay_paycsr['charset']=$epay_setconfig['epaycharset'];	//编码
	
	$epay_paycsr['sign_type']=$epay_setconfig['epaysigntype'];	//加密方式
	
	$epay_paycsr['timestamp']=date("Y-m-d H:i:s");	//发送请求的时间
	
	$epay_paycsr['version']=$epay_setconfig['epayversion'];	//接口版本
	
	$epay_paycsr['app_auth_token']=$epay_setconfig['epayappauthtoken'];	//应用授权
	
	//------------------ 参数结束 ------------------

	//请求参数
	
	$epay_paycsr['biz_content']='{"out_trade_no":"'.$paycsr['out_trade_no'].'","trade_no":"'.$paycsr['trade_no'].'"}';

	//签名
	$paystr_r=alipay_GetSignUrl($epay_paycsr,'sign');
	$epay_paycsr['sign']=$paystr_r['strsign'];

	//支付地址
	$gotopayurl=$epay_setconfig['epayurl'].'?'.$paystr_r['strurl'].'&sign='.urlencode($epay_paycsr['sign']);
	//提交
	$response=epay_CurlPost($gotopayurl,'',false,6,0,0);
	
	//返回
	return $response;
}

//返回处理成功显示内容
function alipay_orderHavePayMsg($result){
	echo"success";
}

?>