<?php

//返回签名和变量地址
function wxpay_GetSignUrl($r,$novar=''){
	global $epay_setconfig;
	$sign='';
	//签名步骤一：按字典序排序参数
	ksort($r);
	$paystr_r=epay_ToUrlParams($r,$novar);
	$paystr=$paystr_r['str'];
	$paystrurl=$paystr_r['strurl'];
	//签名步骤二：在string后加入KEY
	$sign=$paystr.'&key='.$epay_setconfig['epaykey'];
	//签名步骤三：MD5加密或者HMAC-SHA256
	$sign=md5($sign);
	//签名步骤四：所有字符转为大写
	$sign=strtoupper($sign);
	$re_r['str']=$paystr;
	$re_r['strurl']=$paystrurl;
	$re_r['strsign']=$sign;
	return $re_r;
}

//统一下单
function wxpay_unifiedOrder($paycsr){
	global $epay_setconfig;
	//提交地址
	$url='https://api.mch.weixin.qq.com/pay/unifiedorder';
	
	//检测必填参数
	if(!$paycsr['out_trade_no'])
	{
		epay_showmsg('缺少统一支付接口必填参数out_trade_no！','');
	}
	if(!$paycsr['body'])
	{
		epay_showmsg('缺少统一支付接口必填参数body！','');
	}
	if(!$paycsr['total_fee'])
	{
		epay_showmsg('缺少统一支付接口必填参数total_fee！','');
	}
	if(!$paycsr['trade_type'])
	{
		epay_showmsg('缺少统一支付接口必填参数trade_type！','');
	}
		
	//关联参数
	if($paycsr['trade_type']=='JSAPI'&&!$paycsr['openid'])
	{
		epay_showmsg('统一支付接口中，缺少必填参数openid！trade_type为JSAPI时，openid为必填参数！','');
	}
	if($paycsr['trade_type']=='NATIVE'&&!$paycsr['product_id'])
	{
		epay_showmsg('统一支付接口中，缺少必填参数product_id！trade_type为JSAPI时，product_id为必填参数！','');
	}
		
	//异步通知url未设置，则使用配置文件中的url
	if(!$paycsr['notify_url']&&$epay_setconfig['enturl']!='')
	{
		$paycsr['notify_url']=$epay_setconfig['enturl'];
	}
	//公众账号ID
	if(!$paycsr['appid'])
	{
		$paycsr['appid']=$epay_setconfig['eappid'];
	}
	//商户号
	if(!$paycsr['mch_id'])
	{
		$paycsr['mch_id']=$epay_setconfig['epayuser'];
	}
	//终端ip
	if(!$paycsr['spbill_create_ip'])
	{
		$paycsr['spbill_create_ip']=egetip();
	}
	//随机字符串
	if(!$paycsr['nonce_str'])
	{
		$paycsr['nonce_str']=epay_getRndStr(32);
	}
		
	//签名
	$paystr_r=wxpay_GetSignUrl($paycsr,'sign');
	$sign=$paystr_r['strsign'];
	$paycsr['sign']=$sign;
	//提交
	$xml=epay_ToXml($paycsr);
	$response=epay_CurlPost($url,$xml,false,6,0,0);
	//结果处理
	$result=wxpay_OrderResult($response);
	return $result;
}

//返回提交结果,将xml转为array
function wxpay_OrderResult($xml){
	$result_r=epay_FromXml($xml);
	//失败则直接返回失败
	if($result_r['return_code']!='SUCCESS')
	{
		foreach ($result_r as $key => $value)
		{
			//除了return_code和return_msg之外其他的参数存在，则报错
			if($key!="return_code"&&$key!="return_msg")
			{
				epay_showmsg('输入数据存在异常！','');
				return false;
			}
		}
		return $result_r;
	}
	//签名验证
	if(!$result_r['sign'])
	{
		epay_showmsg('签名错误！','');
	}
	$paystr_r=wxpay_GetSignUrl($result_r,'sign');
	$ysign=$paystr_r['strsign'];
	if(!$ysign)
	{
		epay_showmsg('签名错误！','');
	}
	if('dg'.$ysign!='dg'.$result_r['sign'])
	{
		epay_showmsg('签名错误！','');
	}
    return $result_r;
}

//显示二维码
function wxpay_ShowPayImg($result){
	if($result['return_code']=='SUCCESS'&&$result['result_code']=='SUCCESS')
	{}
	else
	{
		epay_showmsg('获取二维码数据失败！','');
	}
	$url=$result['code_url'];
	if(!$url)
	{
		epay_showmsg('获取二维码数据失败！','');
	}
	if(substr($url,0,6)!='weixin')
	{
		epay_showmsg('获取二维码数据失败！','');
	}
	epay_ShowPayImgJs($url,'eewm/','210','210');
}

//查询订单
function wxpay_orderQuery($paycsr){
	global $epay_setconfig;
	//提交地址
	$url='https://api.mch.weixin.qq.com/pay/orderquery';
	
	//检测必填参数
	if(!$paycsr['out_trade_no']&&!$paycsr['transaction_id'])
	{
		epay_showmsg('订单查询接口中，out_trade_no、transaction_id至少填一个！','');
	}
	
	//提交订单号
	if($paycsr['transaction_id'])
	{
		$paycsr['out_trade_no']='';
	}
	//公众账号ID
	if(!$paycsr['appid'])
	{
		$paycsr['appid']=$epay_setconfig['eappid'];
	}
	//商户号
	if(!$paycsr['mch_id'])
	{
		$paycsr['mch_id']=$epay_setconfig['epayuser'];
	}
	//随机字符串
	if(!$paycsr['nonce_str'])
	{
		$paycsr['nonce_str']=epay_getRndStr(32);
	}
	
	//签名
	$paystr_r=wxpay_GetSignUrl($paycsr,'sign');
	$sign=$paystr_r['strsign'];
	$paycsr['sign']=$sign;
	//提交
	$xml=epay_ToXml($paycsr);
	$response=epay_CurlPost($url,$xml,false,6,0,0);
	//结果处理
	$result=wxpay_OrderResult($response);
	return $result;
}

//是否支付成功
function wxpay_orderHavePay($result){
	if($result['return_code']=='SUCCESS'&&$result['result_code']=='SUCCESS'&&$result['trade_state']=='SUCCESS')
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

//返回处理成功显示内容
function wxpay_orderHavePayMsg($result){
	?>
<xml>
  <return_code><![CDATA[SUCCESS]]></return_code>
  <return_msg><![CDATA[OK]]></return_msg>
</xml> 
	<?php
}



?>