<?php

define('InEmpireCMSesms',TRUE);

//返回参数
function esms_SendConfig(){
	$ecms_esmsconfig=array();
	
	//------------------ 接口参数设置开始 ------------------
	
	//网站名称
	$ecms_esmsconfig['smssitename']='帝国CMS';
	
	//接口提交地址
	$ecms_esmsconfig['smsurl']='http://dysmsapi.aliyuncs.com/';
	
	//接口应用ID
	$ecms_esmsconfig['smsappid']='';
	
	//接口ID(accessKeyId)
	$ecms_esmsconfig['smskeyid']='接口ID';
	
	//接口密钥(accessKeySecret)
	$ecms_esmsconfig['smskey']='密钥';
	
	//短信签名
	$ecms_esmsconfig['smssignname']='短信签名';
	
	//短信模板
	$ecms_esmsconfig['smstempid']='短信模板';
	
	//------------------ 接口参数设置结束 ------------------
	
	
	//------------------ 其它参数(一般不用修改) ------------------
	
	//接口版本
	$ecms_esmsconfig['smsver']='2017-05-25';
	
	//接口区域
	$ecms_esmsconfig['smsregion']='cn-hangzhou';
	
	//提交事件
	$ecms_esmsconfig['smsaction']='SendSms';
	
	//------------------ 其它参数(一般不用修改) ------------------
	
	return $ecms_esmsconfig;
}

//提交网页
function esms_PostUrl($url,$data=null){
	if(function_exists('curl_init'))
	{
		$string=eCurlReadtext($url,$data);
	}
	else
	{
		if(!empty($data))
		{
			$url.='?'.$data;
		}
		$string=ReadUrltext($url);
	}
	return $string;
}

//发送短信
function esms_dosend($esmsr,$emethod='GET'){
	$esmsconfig=esms_SendConfig();
	//发送参数
	$sendvar=array();
	//签名参数
	$sendvar['SignatureMethod']='HMAC-SHA1';
	$sendvar['SignatureNonce']=uniqid(mt_rand(0,0xffff),true);
	$sendvar['SignatureVersion']='1.0';
	$sendvar['AccessKeyId']=$esmsconfig['smskeyid'];
	$sendvar['Timestamp']=gmdate("Y-m-d\TH:i:s\Z");
	$sendvar['Format']='JSON';
	//参数
	$sendvar['PhoneNumbers']=$esmsr['send_phno'];
	$sendvar['SignName']=$esmsr['send_signname']?$esmsr['send_signname']:$esmsconfig['smssignname'];
	$sendvar['TemplateCode']=$esmsr['send_tempid']?$esmsr['send_tempid']:$esmsconfig['smstempid'];
	//模板参数
	$esmsr['smstempvar']['code']=$esmsr['send_keystr'];				//验证码
	//$esmsr['smstempvar']['product']=$esmsconfig['smssitename'];		//网站名称
	//模板参数
	if(!empty($esmsr['smstempvar'])&&is_array($esmsr['smstempvar']))
	{
        $sendvar['TemplateParam']=json_encode($esmsr['smstempvar'],JSON_UNESCAPED_UNICODE);
    }
	$sendvar['OutId']=$esmsr['send_sno'];
	$sendvar['SmsUpExtendCode']=$esmsr['send_upcode'];
	//固定
	$sendvar['RegionId']=$esmsconfig['smsregion'];
	$sendvar['Action']=$esmsconfig['smsaction'];
	$sendvar['Version']=$esmsconfig['smsver'];
	//签名
	ksort($sendvar);
	
	$sortedQueryStringTmp='';
    foreach($sendvar as $key => $value)
	{
        $sortedQueryStringTmp.="&".esms_encode($key)."=".esms_encode($value);
    }
	
	$stringToSign=$emethod."&%2F&".esms_encode(substr($sortedQueryStringTmp,1));

    $sign=base64_encode(hash_hmac("sha1",$stringToSign,$esmsconfig['smskey']."&",true));

    $signature=esms_encode($sign);
	
	//发送地址
	$sendurl=$esmsconfig['smsurl'];
	//发送参数
	$sendurlcs='Signature='.$signature.$sortedQueryStringTmp;
	if($emethod=='GET')
	{
		$sendurl.='?'.$sendurlcs;
		$sendurlcs='';
	}
	//提交
	$send_result=esms_PostUrl($sendurl,$sendurlcs);
	//echo $send_result;
	return $send_result;
}

//过滤转码内容
function esms_encode($str){
    $res=urlencode($str);
    $res=str_replace("+","%20",$res);
    $res=str_replace("*","%2A",$res);
    $res=str_replace("%7E","~",$res);
    return $res;
}

?>