<?php
$editor=1;

//字符過濾
function escape_str($str){
	global $public_r;
	if($public_r['bakescapetype']==2)//real_escape_string
	{
		$str=escape_dbstr($str);
	}
	else//addslashes
	{
		$str=escape_addsstr($str);
	}
	return $str;
}

//字符過慮(addslashes)
function escape_addsstr($str){
	$str=addslashes($str);
	$str=str_replace('\\\'','\'\'',$str);
	$str=str_replace("\\\\","\\\\\\\\",$str);
	$str=str_replace('$','\$',$str);
	return $str;
}

//字符過慮(db)
function escape_dbstr($str){
	global $empire,$dbtbpre,$public_r;
	$str=$empire->EDbEscapeStr($str);
	$str=str_replace('\\\'','\'\'',$str);
	$str=str_replace("\\\\","\\\\\\\\",$str);
	$str=str_replace('$','\$',$str);
	return $str;
}

//修復表
function Ebak_Rep($tablename,$dbname,$userid,$username){
	global $empire,$ecms_config;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$dbname=RepPostVar($dbname);
	eCheckStrType(4,$dbname,1);
	$empire->usequery("use $dbname");
	$tablename=eCheckEmptyArray($tablename);
	$count=count($tablename);
	if(empty($count))
	{printerror("MustChangeOneTable","history.go(-1)");}
	for($i=0;$i<$count;$i++)
	{
		if(eCheckStrType(4,$tablename[$i],0)<1)
		{
			continue;
		}
		//$sql1=$empire->query("OPTIMIZE TABLE $tablename[$i];");
		//$sql2=$empire->query("CHECK TABLE $tablename[$i];");
		//$sql3=$empire->query("ANALYZE TABLE $tablename[$i];");
		$sql4=do_dbTableRepTb($tablename[$i]);//pgsql
    }
	$empire->usequery("use ".$ecms_config['db']['dbname']."");
	//操作日誌
	insert_dolog("dbname=".$dbname);
	printerror("RepireTableSuccess","ChangeTable.php?mydbname=$dbname".hReturnEcmsHashStrHref2(0));
}

//優化表
function Ebak_Opi($tablename,$dbname,$userid,$username){
	global $empire,$ecms_config;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$dbname=RepPostVar($dbname);
	eCheckStrType(4,$dbname,1);
	$empire->usequery("use $dbname");
	$tablename=eCheckEmptyArray($tablename);
	$count=count($tablename);
	if(empty($count))
	{printerror("MustChangeOneTable","history.go(-1)");}
	for($i=0;$i<$count;$i++)
	{
		if(eCheckStrType(4,$tablename[$i],0)<1)
		{
			continue;
		}
		$sql1=do_dbTableOpiTb($tablename[$i]);//pgsql
    }
	$empire->usequery("use ".$ecms_config['db']['dbname']."");
	//操作日誌
	insert_dolog("dbname=".$dbname);
	printerror("OptimTableSuccess","ChangeTable.php?mydbname=$dbname".hReturnEcmsHashStrHref2(0));
}

//刪除數據表
function Ebak_Drop($tablename,$dbname,$userid,$username){
	global $empire,$ecms_config;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$dbname=RepPostVar($dbname);
	eCheckStrType(4,$dbname,1);
	$empire->usequery("use $dbname");
	$tablename=eCheckEmptyArray($tablename);
	$count=count($tablename);
	if(empty($count))
	{printerror("MustChangeOneDelTable","history.go(-1)");}
	$a="";
	$first=1;
	for($i=0;$i<$count;$i++)
	{
		eCheckStrType(4,$tablename[$i],1);
		if(empty($first))
		{
			$a.=",";
	    }
		else
		{
			$first=0;
		}
		$a.="".$tablename[$i]."";
    }
	$sql1=do_dbTableDelTb($a,-1);//pgsql
	$empire->usequery("use ".$ecms_config['db']['dbname']."");
	//操作日誌
	insert_dolog("dbname=".$dbname);
	printerror("DelTableSuccess","ChangeTable.php?mydbname=$dbname".hReturnEcmsHashStrHref2(0));
}

//刪除數據庫
function Ebak_DropDb($dbname,$userid,$username){
	global $empire;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$dbname=RepPostVar($dbname);
	if(empty($dbname))
	{printerror("ChangeDropDb","history.go(-1)");}
	eCheckStrType(4,$dbname,1);
	$sql=do_dbDelDatabase($dbname);//pgsql
	if($sql)
	{
		//操作日誌
		insert_dolog("dbname=".$dbname);
		printerror("DropDbSuccess","ChangeDb.php".hReturnEcmsHashStrHref2(1));
	}
	else
	{printerror("DbError","history.go(-1)");}
}

//建立數據庫
function Ebak_CreatDb($dbname,$dbchar,$userid,$username){
	global $empire,$ecms_config;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$dbname=RepPostVar($dbname);
	if(!trim($dbname)){
		printerror("EmptyDbname","history.go(-1)");
	}
	eCheckStrType(4,$dbname,1);
	eCheckStrType(4,$dbchar,1);
	$sql=do_dbAddDatabase($dbname,$dbchar);//pgsql
	if($sql){
		//操作日誌
		insert_dolog("dbname=".$dbname);
		printerror("AddDbSuccess","ChangeDb.php".hReturnEcmsHashStrHref2(1));
	}
	else
	{printerror("DbError","history.go(-1)");}
}

//清空表
function Ebak_EmptyTable($tablename,$dbname,$userid,$username){
	global $empire,$ecms_config;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$dbname=RepPostVar($dbname);
	eCheckStrType(4,$dbname,1);
	$empire->usequery("use $dbname");
	$tablename=eCheckEmptyArray($tablename);
	$count=count($tablename);
	if(empty($count))
	{printerror("MustChangeOneTable","history.go(-1)");}
	for($i=0;$i<$count;$i++)
	{
		if(eCheckStrType(4,$tablename[$i],0)<1)
		{
			continue;
		}
		$sql1=do_dbTableClearTbData($tablename[$i]);//pgsql
    }
	$empire->usequery("use ".$ecms_config['db']['dbname']."");
	//操作日誌
	insert_dolog("dbname=".$dbname);
	printerror("EmptyTableSuccess","ChangeTable.php?mydbname=$dbname".hReturnEcmsHashStrHref2(0));
}

//---------------------------備份
//初使化備份
function Ebak_DoEbak($add,$userid,$username){
	global $empire,$public_r,$fun_r,$ecms_config;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$dbname=RepPostVar($add['mydbname']);
	if(empty($dbname)){
		printerror("NotChangeDbname","history.go(-1)");
	}
	eCheckStrType(4,$dbname,1);
	$tablename=$add['tablename'];
	$tablename=eCheckEmptyArray($tablename);
	$count=count($tablename);
	if(empty($count)){
		printerror("MustChangeOneTable","history.go(-1)");
	}
	$add['baktype']=(int)$add['baktype'];
	$add['filesize']=(int)$add['filesize'];
	$add['bakline']=(int)$add['bakline'];
	$add['autoauf']=(int)$add['autoauf'];
	if((!$add['filesize']&&!$add['baktype'])||(!$add['bakline']&&$add['baktype'])){
		printerror("FileSizeEmpty","history.go(-1)");
	}
	//目錄名
	$add['mypath']=RepPostStr($add['mypath'],1);
	$bakpath=$public_r['bakdbpath'];
	if(empty($add['mypath'])){
		$add['mypath']=$dbname."_".date("YmdHis");
	}
	$add['mypath']=str_replace('.','',$add['mypath']);
	eCheckStrType(5,$add['mypath'],1);
    DoMkdir($bakpath."/".$add['mypath']);
	//生成說明文件
	$readme=$add['readme'];
	$rfile=$bakpath."/".$add['mypath']."/readme.txt";
	$readme.="\r\n\r\nBaktime: ".date("Y-m-d H:i:s");
	WriteFiletext_n($rfile,$readme);

	$b_table="";
	$d_table="";
	for($i=0;$i<$count;$i++){
		$tablename[$i]=RepPostVar($tablename[$i]);
		eCheckStrType(4,$tablename[$i],1);
		$b_table.=$tablename[$i].",";
		$d_table.="\$tb['".$tablename[$i]."']=0;\r\n";
    }
	//去掉最後一個,
	$b_table=substr($b_table,0,strlen($b_table)-1);
	$bakstru=(int)$add['bakstru'];
	$bakstrufour=(int)$add['bakstrufour'];
	$beover=(int)$add['beover'];
	$waitbaktime=(int)$add['waitbaktime'];
	$bakdatatype=(int)$add['bakdatatype'];
	if($add['insertf']=='insert'){
		$insertf='insert';
	}
	else{
		//$insertf='replace';
		$insertf=do_dbReplaceInto(2);
	}
	if($ecms_config['db']['dbver']=='4.0'&&$add['dbchar']=='auto')
	{
		$add['dbchar']='';
	}
	eCheckStrType(4,$add['dbchar'],1);
	eCheckStrType(4,$insertf,1);
	$ckt_autofield=str_replace(',','',$add['autofield']);
	eCheckStrType(5,$ckt_autofield,1);
	$string="<?php
	\$b_table=\"".$b_table."\";
	".$d_table."
	\$b_baktype=".$add['baktype'].";
	\$b_filesize=".$add['filesize'].";
	\$b_bakline=".$add['bakline'].";
	\$b_autoauf=".$add['autoauf'].";
	\$b_dbname=\"".$dbname."\";
	\$b_stru=".$bakstru.";
	\$b_strufour=".$bakstrufour.";
	\$b_dbchar=\"".addslashes($add['dbchar'])."\";
	\$b_beover=".$beover.";
	\$b_insertf=\"".addslashes($insertf)."\";
	\$b_autofield=\",".addslashes($add['autofield']).",\";
	\$b_bakdatatype=".$bakdatatype.";
	?>";
	$cfile=$bakpath."/".$add['mypath']."/config.php";
	WriteFiletext_n($cfile,$string);
	if($add['baktype']){
		$phome='BakExeT';
	}
	else{
		$phome='BakExe';
	}
	echo $fun_r['FirstBakSuccess']."<script>self.location.href='phome.php?phome=$phome&t=0&s=0&p=0&mypath=".$add['mypath']."&waitbaktime=$waitbaktime".hReturnEcmsHashStrHref(0).heformhash_get($phome,1)."';</script>";
	exit();
}

//執行備份(按文件大小)
function Ebak_BakExe($t,$s,$p,$mypath,$alltotal,$thenof,$fnum,$stime=0,$userid=0,$username=''){
	global $empire,$public_r,$fun_r;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	if(empty($mypath)){
		printerror("ErrorUrl","history.go(-1)");
	}
	eCheckStrType(5,$mypath,1);
	$bakpath=$public_r['bakdbpath'];
	$path=$bakpath."/".$mypath;
	@include($path."/config.php");
	if(empty($b_table)){
		printerror("ErrorUrl","history.go(-1)");
	}
	$waitbaktime=(int)$_GET['waitbaktime'];
	if(empty($stime))
	{
		$stime=time();
	}
	$header="<?php
define('INEMPIREBAKDT',TRUE);
@require(\"../../inc/header.php\");
";
	$footer="
@require(\"../../inc/footer.php\");
?>";
	$btb=explode(",",$b_table);
	$count=count($btb);
	$t=(int)$t;
	$s=(int)$s;
	$p=(int)$p;
	//備份完畢
	if($t>=$count)
	{
		insert_dolog("dbname=".$b_dbname);//操作日誌
		$varmessage=$fun_r['BakSuccess']."<br><br>".$fun_r['TotalUseTime'].ToChangeUseTime($stime);
		$GLOBALS['varmessage']=$varmessage;
		printerror('VarMessage','ChangeDb.php'.hReturnEcmsHashStrHref2(1),0,1);
    }
	$dumpsql=Ebak_ReturnVer();
	//選擇數據庫
	$u=$empire->usequery("use $b_dbname");
	//編碼
	if($b_dbchar=='auto')
	{
		if(empty($s))
		{
			$status_r=Ebak_GetTotal($b_dbname,$btb[$t]);
			$collation=Ebak_GetSetChar($status_r['Collation']);
			DoSetDbChar($collation);
			//總記錄數
			$num=$public_r['limittype']?-1:$status_r['Rows'];
		}
		else
		{
			$collation=$_GET['collation'];
			eCheckStrType(4,$collation,1);
			DoSetDbChar($collation);
			$num=(int)$alltotal;
		}
		$dumpsql.=Ebak_ReturnSetNames($collation);
	}
	else
	{
		DoSetDbChar($b_dbchar);
		if(empty($s))
		{
			//總記錄數
			if($public_r['limittype'])
			{
				$num=-1;
			}
			else
			{
				$status_r=Ebak_GetTotal($b_dbname,$btb[$t]);
				$num=$status_r['Rows'];
			}
		}
		else
		{
			$num=(int)$alltotal;
		}
	}
	//備份數據庫結構
	if($b_stru&&empty($s))
	{
		$dumpsql.=Ebak_Returnstru($btb[$t],$b_strufour);
	}
	$sql=$empire->query("select * from ".$btb[$t]."".do_dblimit($num,$s,1));
	//取得字段數
	if(empty($fnum))
	{
		$return_fr=Ebak_ReturnTbfield($b_dbname,$btb[$t],$b_autofield);
		$fieldnum=$return_fr['num'];
		$noautof=$return_fr['autof'];
	}
	else
	{
		$fieldnum=$fnum;
		$noautof=$thenof;
	}
	//完整插入
	$inf='';
	if($b_beover==1)
	{
		$inf='('.Ebak_ReturnInTbfield($b_dbname,$btb[$t]).')';
	}
	//十六進制
	$hexf='';
	if($b_bakdatatype==1)
	{
		$hexf=Ebak_ReturnInStrTbfield($b_dbname,$btb[$t]);
	}
	$b=0;
	while($r=$empire->fetch($sql))
	{
		$b=1;
		$s++;
		$dumpsql.="E_D(\"".$b_insertf." into ".$btb[$t]."".$inf." values(";
		$first=1;
		for($i=0;$i<$fieldnum;$i++)
		{
			//首字段
			if(empty($first))
			{
				$dumpsql.=',';
			}
			else
			{
				$first=0;
			}
			$myi=$i+1;
			if(!isset($r[$i])||strstr($noautof,','.$myi.','))
			{
				$dumpsql.='NULL';
			}
			else
			{
				$dumpsql.=Ebak_ReSqlFtext($r[$i],$b_bakdatatype,$myi,$hexf);
			}
		}
		$dumpsql.=");\");\r\n";
		//是否超過限制
		if(strlen($dumpsql)>=$b_filesize*1024)
		{
			$p++;
			$sfile=$path."/".$btb[$t]."_".$p.".php";
			$dumpsql=$header.$dumpsql.$footer;
			WriteFiletext_n($sfile,$dumpsql);
			$empire->free($sql);
			//echo $fun_r['BakOneDataSuccess'].Ebak_EchoBakSt($btb[$t],$count,$t,$num,$s)."<script>self.location.href='phome.php?phome=BakExe&s=$s&p=$p&t=$t&mypath=$mypath&alltotal=$num&thenof=$noautof&fieldnum=$fieldnum&stime=$stime".hReturnEcmsHashStrHref(0)."';</script>";

			echo"<meta http-equiv=\"refresh\" content=\"".$waitbaktime.";url=phome.php?phome=BakExe&s=$s&p=$p&t=$t&mypath=$mypath&alltotal=$num&thenof=$noautof&fieldnum=$fieldnum&stime=$stime&waitbaktime=$waitbaktime&collation=$collation".hReturnEcmsHashStrHref(0).heformhash_get('BakExe',1)."\">".$fun_r['BakOneDataSuccess'].Ebak_EchoBakSt($btb[$t],$count,$t,$num,$s);
			exit();
		}
	}
	//最後一個備份
	if(empty($p)||$b==1)
	{
		$p++;
		$sfile=$path."/".$btb[$t]."_".$p.".php";
		$dumpsql=$header.$dumpsql.$footer;
		WriteFiletext_n($sfile,$dumpsql);
	}
	Ebak_RepFilenum($p,$btb[$t],$path);
	$t++;
	$empire->free($sql);
	//進入下一個表
	//echo $btb[$t-1].$fun_r['OneTableBakSuccess']."<script>self.location.href='phome.php?phome=BakExe&s=0&p=0&t=$t&mypath=$mypath&stime=$stime".hReturnEcmsHashStrHref(0)."';</script>";

	echo"<meta http-equiv=\"refresh\" content=\"".$waitbaktime.";url=phome.php?phome=BakExe&s=0&p=0&t=$t&mypath=$mypath&stime=$stime&waitbaktime=$waitbaktime".hReturnEcmsHashStrHref(0).heformhash_get('BakExe',1)."\">".$btb[$t-1].$fun_r['OneTableBakSuccess'];
	exit();
}

//執行備份（按記錄）
function Ebak_BakExeT($t,$s,$p,$mypath,$alltotal,$thenof,$fnum,$auf='',$aufval=0,$stime=0,$userid=0,$username=''){
	global $empire,$public_r,$fun_r;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	if(empty($mypath)){
		printerror("ErrorUrl","history.go(-1)");
	}
	eCheckStrType(5,$mypath,1);
	$bakpath=$public_r['bakdbpath'];
	$path=$bakpath."/".$mypath;
	@include($path."/config.php");
	if(empty($b_table)){
		printerror("ErrorUrl","history.go(-1)");
	}
	$waitbaktime=(int)$_GET['waitbaktime'];
	if(empty($stime))
	{
		$stime=time();
	}
	$header="<?php
define('INEMPIREBAKDT',TRUE);
@require(\"../../inc/header.php\");
";
	$footer="
@require(\"../../inc/footer.php\");
?>";
	$btb=explode(",",$b_table);
	$count=count($btb);
	$t=(int)$t;
	$s=(int)$s;
	$p=(int)$p;
	//備份完畢
	if($t>=$count)
	{
		insert_dolog("dbname=".$b_dbname);//操作日誌
		$varmessage=$fun_r['BakSuccess']."<br><br>".$fun_r['TotalUseTime'].ToChangeUseTime($stime);
		$GLOBALS['varmessage']=$varmessage;
		printerror('VarMessage','ChangeDb.php'.hReturnEcmsHashStrHref2(1),0,1);
    }
	$dumpsql=Ebak_ReturnVer();
	//選擇數據庫
	$u=$empire->usequery("use $b_dbname");
	//編碼
	if($b_dbchar=='auto')
	{
		if(empty($s))
		{
			$status_r=Ebak_GetTotal($b_dbname,$btb[$t]);
			$collation=Ebak_GetSetChar($status_r['Collation']);
			DoSetDbChar($collation);
			//總記錄數
			$num=$public_r['limittype']?-1:$status_r['Rows'];
		}
		else
		{
			$collation=$_GET['collation'];
			eCheckStrType(4,$collation,1);
			DoSetDbChar($collation);
			$num=(int)$alltotal;
		}
		$dumpsql.=Ebak_ReturnSetNames($collation);
	}
	else
	{
		DoSetDbChar($b_dbchar);
		if(empty($s))
		{
			//總記錄數
			if($public_r['limittype'])
			{
				$num=-1;
			}
			else
			{
				$status_r=Ebak_GetTotal($b_dbname,$btb[$t]);
				$num=$status_r['Rows'];
			}
		}
		else
		{
			$num=(int)$alltotal;
		}
	}
	//備份數據庫結構
	if($b_stru&&empty($s))
	{
		$dumpsql.=Ebak_Returnstru($btb[$t],$b_strufour);
	}
	//取得字段數
	if(empty($fnum))
	{
		$return_fr=Ebak_ReturnTbfield($b_dbname,$btb[$t],$b_autofield);
		$fieldnum=$return_fr['num'];
		$noautof=$return_fr['autof'];
		$auf=$return_fr['auf'];
	}
	else
	{
		$fieldnum=$fnum;
		$noautof=$thenof;
	}
	//自動識別自增項
	$aufval=(int)$aufval;
	eCheckStrType(4,$auf,1);
	if($b_autoauf==1&&$auf)
	{
		$sql=$empire->query("select * from ".$btb[$t]." where ".$auf.">".$aufval." order by ".$auf."".do_dblimit($b_bakline,0,1));
	}
	else
	{
		$sql=$empire->query("select * from ".$btb[$t]."".do_dblimit($b_bakline,$s,1));
	}
	//完整插入
	$inf='';
	if($b_beover==1)
	{
		$inf='('.Ebak_ReturnInTbfield($b_dbname,$btb[$t]).')';
	}
	//十六進制
	$hexf='';
	if($b_bakdatatype==1)
	{
		$hexf=Ebak_ReturnInStrTbfield($b_dbname,$btb[$t]);
	}
	$b=0;
	while($r=$empire->fetch($sql))
	{
		if($auf)
		{
			$lastaufval=$r[$auf];
		}
		$b=1;
		$s++;
		$dumpsql.="E_D(\"".$b_insertf." into ".$btb[$t]."".$inf." values(";
		$first=1;
		for($i=0;$i<$fieldnum;$i++)
		{
			//首字段
			if(empty($first))
			{
				$dumpsql.=',';
			}
			else
			{
				$first=0;
			}
			$myi=$i+1;
			if(!isset($r[$i])||strstr($noautof,','.$myi.','))
			{
				$dumpsql.='NULL';
			}
			else
			{
				$dumpsql.=Ebak_ReSqlFtext($r[$i],$b_bakdatatype,$myi,$hexf);
			}
		}
		$dumpsql.=");\");\r\n";
	}
	if(empty($b))
	{
		//最後一個備份
		if(empty($p))
		{
			$p++;
			$sfile=$path."/".$btb[$t]."_".$p.".php";
			$dumpsql=$header.$dumpsql.$footer;
			WriteFiletext_n($sfile,$dumpsql);
		}
		Ebak_RepFilenum($p,$btb[$t],$path);
		$t++;
		$empire->free($sql);
		//進入下一個表
		//echo $btb[$t-1].$fun_r['OneTableBakSuccess']."<script>self.location.href='phome.php?phome=BakExeT&s=0&p=0&t=$t&mypath=$mypath&stime=$stime".hReturnEcmsHashStrHref(0)."';</script>";

		echo"<meta http-equiv=\"refresh\" content=\"".$waitbaktime.";url=phome.php?phome=BakExeT&s=0&p=0&t=$t&mypath=$mypath&stime=$stime&waitbaktime=$waitbaktime".hReturnEcmsHashStrHref(0).heformhash_get('BakExeT',1)."\">".$btb[$t-1].$fun_r['OneTableBakSuccess'];
		exit();
	}
	//進入下一組
	$p++;
	$sfile=$path."/".$btb[$t]."_".$p.".php";
	$dumpsql=$header.$dumpsql.$footer;
	WriteFiletext_n($sfile,$dumpsql);
	$empire->free($sql);
	//echo $fun_r['BakOneDataSuccess'].Ebak_EchoBakSt($btb[$t],$count,$t,$num,$s)."<script>self.location.href='phome.php?phome=BakExeT&s=$s&p=$p&t=$t&mypath=$mypath&alltotal=$num&thenof=$noautof&fieldnum=$fieldnum&auf=$auf&aufval=$lastaufval&stime=$stime".hReturnEcmsHashStrHref(0)."';</script>";

	echo"<meta http-equiv=\"refresh\" content=\"".$waitbaktime.";url=phome.php?phome=BakExeT&s=$s&p=$p&t=$t&mypath=$mypath&alltotal=$num&thenof=$noautof&fieldnum=$fieldnum&auf=$auf&aufval=$lastaufval&stime=$stime&waitbaktime=$waitbaktime&collation=$collation".hReturnEcmsHashStrHref(0).heformhash_get('BakExeT',1)."\">".$fun_r['BakOneDataSuccess'].Ebak_EchoBakSt($btb[$t],$count,$t,$num,$s);
	exit();
}

//輸出備份進度條
function Ebak_EchoBakSt($tbname,$tbnum,$tb,$rnum,$r){
	$table=($tb+1).'/'.$tbnum;
	$record=$r;
	if($rnum!=-1)
	{
		$record=$r.'/'.$rnum;
	}
	?>
	<br><br>
	<table width="90%" border="0" align="center" cellpadding="3" cellspacing="1">
		<tr><td height="25">Table Name&nbsp;:&nbsp;<b><?=$tbname?></b></td></tr>
		<tr><td height="25">Table&nbsp;:&nbsp;<b><?=$table?></b></td></tr>
		<tr><td height="25">Record&nbsp;:&nbsp;<b><?=$record?></b></td></tr>
	</table><br><br>
	<?php
}

//輸出恢復進度條
function Ebak_EchoReDataSt($tbname,$tbnum,$tb,$pnum,$p){
	$table=($tb+1).'/'.$tbnum;
	$record=$p.'/'.$pnum;
	?>
	<br><br>
	<table width="90%" border="0" align="center" cellpadding="3" cellspacing="1">
		<tr><td height="25">Table Name&nbsp;:&nbsp;<b><?=$tbname?></b></td></tr>
		<tr><td height="25">Table&nbsp;:&nbsp;<b><?=$table?></b></td></tr>
		<tr><td height="25">File&nbsp;:&nbsp;<b><?=$record?></b></td></tr>
	</table><br><br>
	<?php
}

//取得表記錄數
function Ebak_GetTotal($dbname,$tbname){
	global $empire;
	/*
	$tr=$empire->fetch1("select count(*) AS total from ".$btb[$t]);
	$num=$tr[total];
	*/
	$tr=do_dbTableRowOne($tbname,1);
	return $tr;
}

//返回字符集set
function Ebak_GetSetChar($char){
	global $empire;
	if(empty($char))
	{
		return '';
	}
	$r=$empire->fetch1("SHOW COLLATION LIKE '".$char."';");
	return $r['Charset'];
}

//返回表字段信息
function Ebak_ReturnTbfield($dbname,$tbname,$autofield){
	global $empire;
	$sql=do_dbFieldRowList($tbname);
	$i=0;//字段數
	$autof=",";//去除自增字段列表
	$f='';//自增字段名
	while($r=$empire->fetch($sql))
	{
		$i++;
		if(strstr($autofield,",".$tbname.".".$r['Field'].","))
		{
			$autof.=$i.",";
	    }
		if($r['Extra']=='auto_increment')
		{
			$f=$r['Field'];
		}
    }
	$return_r['num']=$i;
	$return_r['autof']=$autof;
	$return_r['auf']=$f;
	return $return_r;
}

//返回插入字段
function Ebak_ReturnInTbfield($dbname,$tbname){
	global $empire;
	$sql=do_dbFieldRowList($tbname);
	$f='';
	$dh='';
	while($r=$empire->fetch($sql))
	{
		$f.=$dh.''.$r['Field'].'';
		$dh=',';
    }
	return $f;
}

//返回字符字段
function Ebak_ReturnInStrTbfield($dbname,$tbname){
	global $empire;
	$sql=do_dbFieldRowList($tbname);
	$i=0;
	$f='';
	$dh='';
	while($r=$empire->fetch($sql))
	{
		$i++;
		if(!(stristr($r['Type'],'char')||stristr($r['Type'],'text')))
		{
			continue;
		}
		$f.=$dh.$i;
		$dh=',';
    }
	if($f)
	{
		$f=','.$f.',';
	}
	return $f;
}

//返回字段內容
function Ebak_ReSqlFtext($str,$bakdatatype,$i,$tbstrf){
	if($bakdatatype==1&&!empty($str)&&strstr($tbstrf,','.$i.','))
	{
		$restr='0x'.bin2hex($str);
	}
	else
	{
		$restr='\''.escape_str($str).'\'';
	}
	return $restr;
}

//替換文件數
function Ebak_RepFilenum($p,$table,$path){
	if(empty($p))
	{$p=0;}
	$file=$path."/config.php";
	$text=ReadFiletext($file);
	$rep1="\$tb['".$table."']=0;";
	$rep2="\$tb['".$table."']=".$p.";";
	$text=str_replace($rep1,$rep2,$text);
	WriteFiletext_n($file,$text);
}

//執行SQL
function E_D($sql){
	global $empire;
	$empire->query($sql);
}

//建立表
function E_C($sql){
	global $empire;
	$empire->query(Ebak_AddDbchar($sql));
}

//轉為Mysql4.0格式
function Ebak_ToMysqlFour($query){
	global $ecms_config;
	if($ecms_config['db']['usedb']=='pgsql')//pgsql
	{
		return $query;
	}
	$exp="ENGINE=";
	if(!strstr($query,$exp))
	{
		return $query;
	}
	$exp1=" ";
	$r=explode($exp,$query);
	//取得表類型
	$r1=explode($exp1,$r[1]);
	$returnquery=$r[0]."TYPE=".$r1[0];
	return $returnquery;
}

//---------------------返回數據庫結構
function Ebak_Returnstru($table,$strufour){
	global $empire;
	$dumpsql.="E_D(\"".do_dbTableDelTbSql($table)."\");\r\n";
	//數據表結構
	$create=do_dbTableStruSql($table);//pgsql
	//轉為4.0格式
	if($strufour)
	{
		$create=Ebak_ToMysqlFour($create);
	}
	$dumpsql.="E_C(\"".$create."\");\r\n";
	return $dumpsql;
}

//返回設置編碼
function Ebak_ReturnSetNames($char){
	if(empty($char))
	{
		return '';
	}
	$dumpsql="DoSetDbChar('".$char."');\r\n";
	return $dumpsql;
}

//去除字段中的編碼
function Ebak_ReplaceFieldChar($sql){
	global $ecms_config;
	if($ecms_config['db']['usedb']=='pgsql')//pgsql
	{
		return $sql;
	}
	if($ecms_config['db']['dbver']=='4.0'&&strstr($sql,' character set '))
	{
		$preg_str="/ character set (.+?) collate (.+?) /is";
		$sql=preg_replace($preg_str,' ',$sql);
	}
	return $sql;
}

//加編碼
function Ebak_AddDbchar($sql){
	global $ecms_config,$b_dbchar;
	//加編碼
	if($ecms_config['db']['dbver']>='4.1'&&!strstr($sql,'ENGINE=')&&($ecms_config['db']['setchar']||$b_dbchar)&&$b_dbchar!='auto')
	{
		$dbcharset=$b_dbchar?$b_dbchar:$ecms_config['db']['setchar'];
		$sql=Ebak_DoCreateTable($sql,$ecms_config['db']['dbver'],$dbcharset);
	}
	elseif($ecms_config['db']['dbver']=='4.0'&&strstr($sql,'ENGINE='))
	{
		$sql=Ebak_ToMysqlFour($sql);
	}
	//去除字段中的編碼
	$sql=Ebak_ReplaceFieldChar($sql);
	return $sql;
}

//建表
function Ebak_DoCreateTable($sql,$mysqlver,$dbcharset){
	//pgsql
	return do_dbTableCreateSql($sql,$mysqlver,$dbcharset);
}

//返回版權信息
function Ebak_ReturnVer()
{
	$string="
/*
		SoftName : EmpireBak
		Author   : wm_chief
		Copyright: Powered by www.phome.net
*/

";
	return $string;
}

//轉換大小
function Ebak_ChangeSize($size){
	if($size<1024)
	{
		$str=$size." B";
	}
	elseif($size<1024*1024)
	{
		$str=round($size/1024,2)." KB";
	}
	elseif($size<1024*1024*1024)
	{
		$str=round($size/(1024*1024),2)." MB";
	}
	else
	{
		$str=round($size/(1024*1024*1024),2)." GB";
	}
	return $str;
}

//導入數據
function Ebak_ReData($add,$mypath,$userid,$username){
	global $empire,$public_r;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$mypath=RepPostStr($mypath,1);
	$add['mydbname']=RepPostStr($add['mydbname'],1);
	if(empty($mypath)||empty($add['mydbname']))
	{printerror("EmptyDbnamePath","history.go(-1)");}
	eCheckStrType(5,$mypath,1);
	eCheckStrType(4,$add['mydbname'],1);
	$bakpath=$public_r['bakdbpath'];
	$path=$bakpath."/".$mypath;
	if(!file_exists($path))
	{
		printerror("DbPathNotExist","history.go(-1)");
    }
	@include($path."/config.php");
	if(empty($b_table))
	{
		printerror("BakCsError","history.go(-1)");
	}
	$waitbaktime=(int)$add['waitbaktime'];
	$btb=explode(",",$b_table);
	$nfile=$path."/".$btb[0]."_1.php?t=0&p=0&mydbname=".$add['mydbname']."&mypath=$mypath&waitbaktime=$waitbaktime&phome=ReDataF".hReturnEcmsHashStrHref(0).heformhash_get('ReDataF',1);
	Header("Location:$nfile");
	exit();
}

//刪除備份目錄
function Ebak_DelBakpath($path,$userid,$username){
	global $public_r;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$path=RepPostStr($path,1);
	if(strstr($path,".."))
	{printerror("NotChangeDelPath","history.go(-1)");}
	if(!trim($path))
	{printerror("NotChangeDelPath","history.go(-1)");}
	eCheckStrType(5,$path,1);
	$bakpath=$public_r['bakdbpath'];
	$delpath=$bakpath."/".$path;
	if(!file_exists($delpath))
	{
		printerror("ThisPathNotExist","history.go(-1)");
    }
	@include_once("../../../e/class/delpath.php");
	$delpath=DelPath2($delpath);
	//操作日誌
	insert_dolog("path=".$path);
	printerror("DelPathSuccess","ChangePath.php?change=".RepPostStr($_GET['change'],1).hReturnEcmsHashStrHref2(0));
}

//打包目錄
function ZipFile($path,$zipname){
	global $public_r;
	$bakpath=$public_r['bakdbpath'];
	$bakzippath=$public_r['bakdbzip'];
	@include("../../../e/class/phpzip.inc.php");
	$z=new PHPZip(); //新建立一個zip的類
    $z->Zip($bakpath."/".$path,$bakzippath."/".$zipname); //添加指定目錄
}

//刪除壓縮包
function Ebak_DelZip($file,$userid,$username){
	global $public_r;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$file=RepPostStr($file,1);
	if(strstr($file,".."))
	{printerror("FileNotExist","history.go(-1)",8);}
	if(empty($file))
	{
		printerror("FileNotExist","history.go(-1)",8);
    }
	eCheckStrType(5,$file,1);
	$bakzippath=$public_r['bakdbzip'];
	$filename=$bakzippath."/".$file;
	if(!file_exists($filename))
	{
		printerror("FileNotExist","history.go(-1)",8);
	}
	DelFiletext2($filename);
	//操作日誌
	insert_dolog("file=".$file);
	printerror("DelZipFileSuccess","history.go(-1)",8);
}

//壓縮目錄
function Ebak_Dozip($path,$userid,$username){
	global $public_r;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$path=RepPostStr($path,1);
	if(strstr($path,".."))
	{printerror("ThisPathNotExist","history.go(-1)",8);}
	if(empty($path))
	{
		printerror("ThisPathNotExist","history.go(-1)",8);
    }
	eCheckStrType(5,$path,1);
	$bakpath=$public_r['bakdbpath'];
    $bakzippath=$public_r['bakdbzip'];
	$mypath=$bakpath."/".$path;
	if(!file_exists($mypath))
	{
		printerror("ThisPathNotExist","history.go(-1)",8);
	}
	$zipname=$path.make_password(10).".zip";
	ZipFile($path,$zipname);
	echo"<script>self.location.href='DownZip.php?f=$zipname&p=$path".hReturnEcmsHashStrHref2(0)."';</script>";
}

//轉向恢復頁面
function Ebak_PathGotoRedata($path,$userid,$username){
	global $public_r;
	//驗證權限
	CheckLevel($userid,$username,$classid,"dbdata");
	$path=RepPostStr($path,1);
	if(strstr($path,".."))
	{printerror("NotChangeDelPath","history.go(-1)");}
	if(!trim($path))
	{printerror("NotChangeDelPath","history.go(-1)");}
	eCheckStrType(5,$path,1);
	$bakpath=$public_r['bakdbpath'];
	$repath=$bakpath."/".$path;
	if(!file_exists($repath))
	{
		printerror("ThisPathNotExist","history.go(-1)");
    }
	@include $repath.'/config.php';
	Header("Location:ReData.php?mydbname=$b_dbname&mypath=$path".hReturnEcmsHashStrHref2(0));
	exit();
}
?>